package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Coyot_trunk extends Trunk
{
	public Coyot_trunk( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Coyot trunk";

		value = 200;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.coyot:0x000000FEr, "RL brake light", actcolor, optical, power );
			addPart( cars.cat_01.coyot:0x00000106r, "RR brake light", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000FEr, "RL brake light", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x00000106r, "RR brake light", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical > 1.0 )
		{
			float part_random = random();
			if ( part_random >= 0.5 ) addPart( cars.cat_01.coyot:0x000000FDr, "R wing 2", actcolor, optical, power ); else
			addPart( cars.cat_01.coyot:0x000000FCr, "R wing", actcolor, optical, power );
		}
	}
}
